/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.core.util.SourcePrinter;
import com.aptana.scripting.model.AbstractBundleElement;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectSampleElement
extends AbstractBundleElement {
    private static final String DEFAULT_ICON = "default";
    private String fSampleId;
    private String fCategoryId;
    private String fLocation;
    private String fDescription;
    private String[] fProjectNatures;
    private IPath fDestinationPath;
    private Map<String, String> fIconPaths;
    private Map<String, URL> fIconUrls;

    public ProjectSampleElement(String path) {
        super(path);
        this.fIconPaths = new HashMap<String, String>();
        this.fIconUrls = new HashMap<String, URL>();
    }

    public ProjectSampleElement(String sourcePath, String id, String displayName, String categoryId, String description, URL icon, IPath destinationPath, String[] natures) {
        super(sourcePath);
        this.fLocation = sourcePath;
        this.fSampleId = id;
        this.fCategoryId = categoryId;
        this.fDescription = description;
        this.fDestinationPath = destinationPath;
        this.fProjectNatures = natures;
        this.fIconPaths = new HashMap<String, String>();
        this.fIconUrls = new HashMap<String, URL>();
        this.setDisplayName(displayName);
        this.setIcon(DEFAULT_ICON, icon.toExternalForm());
    }

    public String getId() {
        return this.fSampleId;
    }

    public String getCategory() {
        return this.fCategoryId;
    }

    public String getLocation() {
        return this.fLocation;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String[] getNatures() {
        return this.fProjectNatures;
    }

    public Map<String, String> getIcon() {
        return this.fIconPaths;
    }

    public Map<String, URL> getIconUrls() {
        Map<String, String> iconPaths = this.getIcon();
        Set<String> iconSizes = iconPaths.keySet();
        for (String size : iconSizes) {
            URL iconUrl;
            String iconPath = iconPaths.get(size);
            if (iconPath == null || (iconUrl = this.fIconUrls.get(size)) != null) continue;
            iconUrl = this.getURLFromPath(iconPath);
            this.fIconUrls.put(size, iconUrl);
        }
        return this.fIconUrls;
    }

    public File getDirectory() {
        return this.getOwningBundle().getBundleDirectory();
    }

    @Override
    public String getElementName() {
        return "project_sample";
    }

    public void setId(String id) {
        this.fSampleId = id;
    }

    public void setDescription(String description) {
        this.fDescription = description;
    }

    public void setLocation(String location) {
        this.fLocation = location;
    }

    public void setCategory(String categoryId) {
        this.fCategoryId = categoryId;
    }

    public void setNatures(String[] natures) {
        this.fProjectNatures = natures;
    }

    public IPath getDestinationPath() {
        return this.fDestinationPath;
    }

    public void setIcon(String defaultIcon) {
        this.setIcon(DEFAULT_ICON, defaultIcon);
    }

    public void setIcon(Map<String, String> iconMap) {
        Set<String> iconSizes = iconMap.keySet();
        for (String size : iconSizes) {
            this.setIcon(size, iconMap.get(size));
        }
    }

    public void setIcon(String iconSize, String iconPath) {
        this.fIconPaths.put(iconSize, iconPath);
        this.fIconUrls.remove(iconSize);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProjectSampleElement)) {
            return false;
        }
        ProjectSampleElement other = (ProjectSampleElement)obj;
        return this.getCategory().equals(other.getCategory()) && this.getId().equals(other.getId()) && this.getLocation().equals(other.getLocation());
    }

    public int hashCode() {
        int hash = this.getCategory().hashCode();
        hash = 31 * hash + this.getId().hashCode();
        hash = 31 * hash + this.getLocation().hashCode();
        return hash;
    }

    @Override
    protected void printBody(SourcePrinter printer, boolean includeBlocks) {
        Map<String, URL> iconUrls;
        int count;
        String[] natures;
        printer.printWithIndent("id: ").println(this.getId());
        printer.printlnWithIndent("category: ").println(this.getCategory());
        printer.printWithIndent("name: ").println(this.getDisplayName());
        printer.printWithIndent("location: ").println(this.getLocation());
        String description = this.getDescription();
        if (description != null) {
            printer.printWithIndent("description: ").println(description);
        }
        if ((natures = this.getNatures()) != null && (count = natures.length) > 0) {
            StringBuilder natureStr = new StringBuilder();
            natureStr.append('[');
            int i = 0;
            while (i < count) {
                natureStr.append(natures[i]);
                if (i < count - 1) {
                    natureStr.append(", ");
                }
                ++i;
            }
            natureStr.append(']');
            printer.printWithIndent("natures: ").println(natureStr.toString());
        }
        if ((iconUrls = this.getIconUrls()).size() > 0) {
            printer.printWithIndent("iconURL: ");
            StringBuilder text = new StringBuilder();
            Set<String> iconSizes = iconUrls.keySet();
            for (String size : iconSizes) {
                text.append(size).append('=').append(iconUrls.get(size)).append(',');
            }
            text.deleteCharAt(text.length() - 1);
            printer.println(text.toString());
        }
    }
}

